

//<![CDATA[

<!--


//MDH_SCORM modification to support SCORM 1.2 functionality on LMS
/* JavaScript to find the SCORM API if it is available */
/* Based on a model at <http://www.claroline.net/doc/en/index.php/How_do_I_create_SCORM_content%3F> */

var API = null; /* SCORM API */

/* look up through the frameset hierarchy for the SCORM API */
function findAPI(win)
{
	while ((win.API == null) && (win.parent != null) && (win.parent != win))
	{
		win = win.parent;
	}
	API = win.API;
}

/* initialize the SCORM API */
function initAPI(win)
{
	/* look for the SCORM API up in the frameset */
	findAPI(win);

	/* if we still have not found the API, look at the opener and its frameset */
	if ((API == null) && (win.opener != null))
	{
		findAPI(win.opener);
	}
}

var ScormSubmitted = false; //use this to check whether LMSFinish has been called later.

function ScormStartUp(){
	initAPI(window);
	if (API != null){
		API.LMSInitialize(''); 
		API.LMSSetValue('cmi.core.lesson_status', 'browsed');
		API.LMSSetValue('cmi.core.score.min', 0);
		API.LMSSetValue('cmi.core.score.max', 100);
		API.LMSCommit('');
	}
}

function CheckLMSFinish(){
	if (API != null){
		if (ScormSubmitted == false){
			API.LMSCommit('');
			API.LMSFinish('');
			ScormSubmitted = true;
		}
	}
}

function SetScormIncomplete(){
	if (ScormSubmitted == true){
		return;
	}
	SetScormScore();
	if (API != null){
		API.LMSSetValue('cmi.core.lesson_status', 'incomplete');
		API.LMSSetValue('cmi.core.session_time', MillisecondsToTime((new Date()).getTime() - ScormStartTime));
		API.LMSCommit('');
	}
}

function SetScormComplete(){
	if (API != null){
		API.LMSSetValue('cmi.core.session_time', MillisecondsToTime((new Date()).getTime() - ScormStartTime));
		API.LMSSetValue('cmi.core.lesson_status', 'completed');
		SetScormScore();
		API.LMSCommit('');
		API.LMSFinish('');
		ScormSubmitted = true;
	}
}

var ScormStartTime = (new Date()).getTime();

var SuspendData = '';

function SetScormTimedOut(){
	if (API != null){
		if (ScormSubmitted == false){
			SetScormScore();
			API.LMSSetValue('cmi.core.exit', 'time-out'); 
			API.LMSCommit('');
			CheckLMSFinish();
		}
	}
}

//TIME RENDERING FUNCTION
function MillisecondsToTime(Seconds){
	Seconds = Math.round(Seconds/1000);
	var S = Seconds % 60;
	Seconds -= S;
	if (S < 10){S = '0' + S;}
	var M = (Seconds / 60) % 60;
	if (M < 10){M = '0' + M;}
	var H = Math.floor(Seconds / 3600);
	if (H < 10){H = '0' + H;}
	return H + ':' + M + ':' + S;
}




function Client(){
//if not a DOM browser, hopeless
	this.min = false; if (document.getElementById){this.min = true;};

	this.ua = navigator.userAgent;
	this.name = navigator.appName;
	this.ver = navigator.appVersion;  

//Get data about the browser
	this.mac = (this.ver.indexOf('Mac') != -1);
	this.win = (this.ver.indexOf('Windows') != -1);

//Look for Gecko
	this.gecko = (this.ua.indexOf('Gecko') > 1);
	if (this.gecko){
		this.geckoVer = parseInt(this.ua.substring(this.ua.indexOf('Gecko')+6, this.ua.length));
		if (this.geckoVer < 20020000){this.min = false;}
	}
	
//Look for Firebird
	this.firebird = (this.ua.indexOf('Firebird') > 1);
	
//Look for Safari
	this.safari = (this.ua.indexOf('Safari') > 1);
	if (this.safari){
		this.gecko = false;
	}
	
//Look for IE
	this.ie = (this.ua.indexOf('MSIE') > 0);
	if (this.ie){
		this.ieVer = parseFloat(this.ua.substring(this.ua.indexOf('MSIE')+5, this.ua.length));
		if (this.ieVer < 5.5){this.min = false;}
	}
	
//Look for Opera
	this.opera = (this.ua.indexOf('Opera') > 0);
	if (this.opera){
		this.operaVer = parseFloat(this.ua.substring(this.ua.indexOf('Opera')+6, this.ua.length));
		if (this.operaVer < 7.04){this.min = false;}
	}
	if (this.min == false){
		alert('Your browser may not be able to handle this page.');
	}
	
//Special case for the horrible ie5mac
	this.ie5mac = (this.ie&&this.mac&&(this.ieVer<6));
}

var C = new Client();

//for (prop in C){
//	alert(prop + ': ' + C[prop]);
//}



//CODE FOR HANDLING NAV BUTTONS AND FUNCTION BUTTONS

//[strNavBarJS]
function NavBtnOver(Btn){
	if (Btn.className != 'NavButtonDown'){Btn.className = 'NavButtonUp';}
}

function NavBtnOut(Btn){
	Btn.className = 'NavButton';
}

function NavBtnDown(Btn){
	Btn.className = 'NavButtonDown';
}
//[/strNavBarJS]

function FuncBtnOver(Btn){
	if (Btn.className != 'FuncButtonDown'){Btn.className = 'FuncButtonUp';}
}

function FuncBtnOut(Btn){
	Btn.className = 'FuncButton';
}

function FuncBtnDown(Btn){
	Btn.className = 'FuncButtonDown';
}

function FocusAButton(){
	if (document.getElementById('CheckButton1') != null){
		document.getElementById('CheckButton1').focus();
	}
	else{
		if (document.getElementById('CheckButton2') != null){
			document.getElementById('CheckButton2').focus();
		}
		else{
			document.getElementsByTagName('button')[0].focus();
		}
	}
}




//CODE FOR HANDLING DISPLAY OF POPUP FEEDBACK BOX

var topZ = 1000;

function ShowMessage(Feedback){
	var Output = Feedback + '<br /><br />';
	document.getElementById('FeedbackContent').innerHTML = Output;
	var FDiv = document.getElementById('FeedbackDiv');
	topZ++;
	FDiv.style.zIndex = topZ;
	FDiv.style.top = TopSettingWithScrollOffset(30) + 'px';

	FDiv.style.display = 'block';

	ShowElements(false, 'input');
	ShowElements(false, 'select');
	ShowElements(false, 'object');
	ShowElements(true, 'object', 'FeedbackContent');

//Focus the OK button
	setTimeout("document.getElementById('FeedbackOKButton').focus()", 50);
	
//
//	RefreshImages();
//
}

function ShowElements(Show, TagName, ContainerToReverse){
// added third argument to allow objects in the feedback box to appear
//IE bug -- hide all the form elements that will show through the popup
//FF on Mac bug : doesn't redisplay objects whose visibility is set to visible
//unless the object's display property is changed

	//get container object (by Id passed in, or use document otherwise)
	TopNode = document.getElementById(ContainerToReverse);
	var Els;
	if (TopNode != null) {
		Els = TopNode.getElementsByTagName(TagName);
	} else {
		Els = document.getElementsByTagName(TagName);
	}

	for (var i=0; i<Els.length; i++){
		if (TagName == "object") {
			//manipulate object elements in all browsers
			if (Show == true){
				Els[i].style.visibility = 'visible';
				//get Mac FireFox to manipulate display, to force screen redraw
				if (C.mac && C.gecko) {Els[i].style.display = '';}
			}
			else{
				Els[i].style.visibility = 'hidden';
				if (C.mac && C.gecko) {Els[i].style.display = 'none';}
			}
		} 
		else {
			// tagName is either input or select (that is, Form Elements)
			// ie6 has a problem with Form elements, so manipulate those
			if (C.ie) {
				if (C.ieVer < 7) {
					if (Show == true){
						Els[i].style.visibility = 'visible';
					}
					else{
						Els[i].style.visibility = 'hidden';
					}
				}
			}
		}
	}
}



function HideFeedback(){
	document.getElementById('FeedbackDiv').style.display = 'none';
	ShowElements(true, 'input');
	ShowElements(true, 'select');
	ShowElements(true, 'object');
	if (Finished == true){
		Finish();
	}
	//modif HQeL (&#224; voir : changement automatique de question mais pb si derni&#232;re question non renseign&#233;e pour message d'avertissement.)
	//else {ChangeQ(1);}
}


//GENERAL UTILITY FUNCTIONS AND VARIABLES

//PAGE DIMENSION FUNCTIONS
function PageDim(){
//Get the page width and height
	this.W = 600;
	this.H = 400;
	this.W = document.getElementsByTagName('body')[0].clientWidth;
	this.H = document.getElementsByTagName('body')[0].clientHeight;
}

var pg = null;

function GetPageXY(El) {
	var XY = {x: 0, y: 0};
	while(El){
		XY.x += El.offsetLeft;
		XY.y += El.offsetTop;
		El = El.offsetParent;
	}
	return XY;
}

function GetScrollTop(){
	if (document.documentElement && document.documentElement.scrollTop){
		return document.documentElement.scrollTop;
	}
	else{
		if (document.body){
 			return document.body.scrollTop;
		}
		else{
			return window.pageYOffset;
		}
	}
}

function GetViewportHeight(){
	if (window.innerHeight){
		return window.innerHeight;
	}
	else{
		return document.getElementsByTagName('body')[0].clientHeight;
	}
}

function TopSettingWithScrollOffset(TopPercent){
	var T = Math.floor(GetViewportHeight() * (TopPercent/100));
	return GetScrollTop() + T; 
}

//CODE FOR AVOIDING LOSS OF DATA WHEN BACKSPACE KEY INVOKES history.back()
var InTextBox = false;

function SuppressBackspace(e){ 
	if (InTextBox == true){return;}
	if (C.ie) {
		thisKey = window.event.keyCode;
	}
	else {
		thisKey = e.keyCode;
	}

	var Suppress = false;

	if (thisKey == 8) {
		Suppress = true;
	}

	if (Suppress == true){
		if (C.ie){
			window.event.returnValue = false;	
			window.event.cancelBubble = true;
		}
		else{
			e.preventDefault();
		}
	}
}

if (C.ie){
	document.attachEvent('onkeydown',SuppressBackspace);
	window.attachEvent('onkeydown',SuppressBackspace);
}
else{
	if (window.addEventListener){
		window.addEventListener('keypress',SuppressBackspace,false);
	}
}

function ReduceItems(InArray, ReduceToSize){
	var ItemToDump=0;
	var j=0;
	while (InArray.length > ReduceToSize){
		ItemToDump = Math.floor(InArray.length*Math.random());
		InArray.splice(ItemToDump, 1);
	}
}

function Shuffle(InArray){
	var Num;
	var Temp = new Array();
	var Len = InArray.length;

	var j = Len;

	for (var i=0; i<Len; i++){
		Temp[i] = InArray[i];
	}

	for (i=0; i<Len; i++){
		Num = Math.floor(j  *  Math.random());
		InArray[i] = Temp[Num];

		for (var k=Num; k < (j-1); k++) {
			Temp[k] = Temp[k+1];
		}
		j--;
	}
	return InArray;
}

function WriteToInstructions(Feedback) {
	document.getElementById('InstructionsDiv').innerHTML = Feedback;

	RefreshImages();

}



Imgs = new Array();

function PreloadImages(){
	var a = PreloadImages.arguments;
	for (var i=0; i<a.length; i++){
		Imgs[i] = new Image();
		Imgs[i].src = a[i];
	}
}

function RefreshImages(){
	for (var i=0; i<document.images.length; i++){
		if (document.images[i].name.substring(0,6) != 'NavBar'){
			document.images[i].src = document.images[i].src;
		}
	}
}


function EscapeDoubleQuotes(InString){
	return InString.replace(/"/g, '&quot;')
}

function TrimString(InString){
        var x = 0;

        if (InString.length != 0) {
                while ((InString.charAt(InString.length - 1) == '\u0020') || (InString.charAt(InString.length - 1) == '\u000A') || (InString.charAt(InString.length - 1) == '\u000D')){
                        InString = InString.substring(0, InString.length - 1)
                }

                while ((InString.charAt(0) == '\u0020') || (InString.charAt(0) == '\u000A') || (InString.charAt(0) == '\u000D')){
                        InString = InString.substring(1, InString.length)
                }

                while (InString.indexOf('  ') != -1) {
                        x = InString.indexOf('  ')
                        InString = InString.substring(0, x) + InString.substring(x+1, InString.length)
                 }

                return InString;
        }

        else {
                return '';
        }
}

function FindLongest(InArray){
	if (InArray.length < 1){return -1;}

	var Longest = 0;
	for (var i=1; i<InArray.length; i++){
		if (InArray[i].length > InArray[Longest].length){
			Longest = i;
		}
	}
	return Longest;
}

//UNICODE CHARACTER FUNCTIONS
function IsCombiningDiacritic(CharNum){
	var Result = (((CharNum >= 0x0300)&&(CharNum <= 0x370))||((CharNum >= 0x20d0)&&(CharNum <= 0x20ff)));
	Result = Result || (((CharNum >= 0x3099)&&(CharNum <= 0x309a))||((CharNum >= 0xfe20)&&(CharNum <= 0xfe23)));
	return Result;
}

function IsCJK(CharNum){
	return ((CharNum >= 0x3000)&&(CharNum < 0xd800));
}

//SETUP FUNCTIONS
//BROWSER WILL REFILL TEXT BOXES FROM CACHE IF NOT PREVENTED
function ClearTextBoxes(){
	var NList = document.getElementsByTagName('input');
	for (var i=0; i<NList.length; i++){
		if ((NList[i].id.indexOf('Guess') > -1)||(NList[i].id.indexOf('Gap') > -1)){
			NList[i].value = '';
		}
		if (NList[i].id.indexOf('Chk') > -1){
			NList[i].checked = '';
		}
	}
}

//EXTENSION TO ARRAY OBJECT
function Array_IndexOf(Input){
	var Result = -1;
	for (var i=0; i<this.length; i++){
		if (this[i] == Input){
			Result = i;
		}
	}
	return Result;
}
Array.prototype.indexOf = Array_IndexOf;

//IE HAS RENDERING BUG WITH BOTTOM NAVBAR
function RemoveBottomNavBarForIE(){
	if ((C.ie)&&(document.getElementById('Reading') != null)){
		if (document.getElementById('BottomNavBar') != null){
			document.getElementById('TheBody').removeChild(document.getElementById('BottomNavBar'));
		}
	}
}




//HOTPOTNET-RELATED CODE

var HPNStartTime = (new Date()).getTime();
var SubmissionTimeout = 30000;
var Detail = ''; //Global that is used to submit tracking data

function Finish(){
//If there's a form, fill it out and submit it
	if (document.store != null){
		Frm = document.store;
		Frm.starttime.value = HPNStartTime;
		Frm.endtime.value = (new Date()).getTime();
		Frm.mark.value = Score;
		Frm.detail.value = Detail;
		Frm.submit();
	}
}




//JQUIZ-SPECIFIC SCORM-RELATED JAVASCRIPT CODE

function SetScormScore(){
//Reports the current score and any other information back to the LMS
	if (API != null){
		API.LMSSetValue('cmi.core.score.raw', Score);  //&#224; enlever si modif HQeL : on n'envoie que le score final, pas les scores interm&#233;diaires (nuls)
                                  //var StatusCompleted=true; // si modif HQeL on va regarder si le test est termin&#233; avant d'envoyer le score
//Now send detailed reports about each item
		for (var i=0; i<State.length; i++){
			if (State[i] != null){
				var ItemLabel = 'Item_' + (i+1).toString();
				var ThisItemScore = '';
				var ThisItemStatus = '';
				API.LMSSetValue('cmi.objectives.' + i + '.id', 'obj'+ItemLabel);
				API.LMSSetValue('cmi.interactions.' + i + '.id', 'int'+ItemLabel);
				API.LMSSetValue('cmi.objectives.' + i + '.score.min', '0');
				API.LMSSetValue('cmi.objectives.' + i + '.score.max', '100');
				if (State[i][2] > 0){
					ThisItemScore = Math.floor(State[i][0] * 100) + '';
					ThisItemStatus = 'completed';
				}
				else{
					ThisItemScore = '0';
					ThisItemStatus = 'incomplete';
				}
                                        // si modif HQeL score final seulement, on regarde si le questionnaire est termin&#233;
                                       //StatusCompleted=(StatusCompleted)&&(ThisItemStatus=='completed');
				API.LMSSetValue('cmi.objectives.' + i + '.score.raw', ThisItemScore);
				API.LMSSetValue('cmi.objectives.' + i + '.status', ThisItemStatus);
				API.LMSSetValue('cmi.interactions.' + i + '.weighting', I[i][0]);
//We can only use the performance type, because we're storing multiple responses of various types.
				API.LMSSetValue('cmi.interactions.' + i + '.type', 'performance');
				API.LMSSetValue('cmi.interactions.' + i + '.student_response', State[i][5]);
			}
		}
		     // si modif HQeL : on n'envoie le score que quand on a r&#233;pondu &#224; tout
		    //if (StatusCompleted) {
		   //API.LMSSetValue('cmi.core.score.raw', Score);}
		API.LMSCommit('');
	}
}


//JQUIZ CORE JAVASCRIPT CODE

var CurrQNum = 0;
var CorrectIndicator = 'X';
var IncorrectIndicator = 'X';
var YourScoreIs = '';
var ContinuousScoring = false;
var CorrectFirstTime = '';
var ShowCorrectFirstTime = false;
var ShuffleQs = true;
var ShuffleAs = true;
var DefaultRight = '';
var DefaultWrong = '';
var QsToShow = 5;
var Score = 0;
var Finished = false;
var Qs = null;
var QArray = new Array();
var ShowingAllQuestions = false;
var ShowAllQuestionsCaption = 'Toutes les questions';
var ShowOneByOneCaption = 'Une question par page';
var State = new Array();
var Feedback = '';
var TimeOver = false;
var strInstructions = '';
var Locked = false;

//The following variable can be used to add a message explaining that
//the question is finished, so no further marking will take place.
var strQuestionFinished = '';

function CompleteEmptyFeedback(){
	var QNum, ANum;
	for (QNum=0; QNum<I.length; QNum++){
//Only do this if not multi-select
		if (I[QNum][2] != '3'){
  		for (ANum = 0; ANum<I[QNum][3].length; ANum++){
  			if (I[QNum][3][ANum][1].length < 1){
  				if (I[QNum][3][ANum][2] > 0){
  					I[QNum][3][ANum][1] = DefaultRight;
  				}
  				else{
  					I[QNum][3][ANum][1] = DefaultWrong;
  				}
  			}
  		}
		}
	}
}

function SetUpQuestions(){
	var AList = new Array(); 
	var QList = new Array();
	var i, j;
	Qs = document.getElementById('Questions');
	while (Qs.getElementsByTagName('li').length > 0){
		QList.push(Qs.removeChild(Qs.getElementsByTagName('li')[0]));
	}
	var DumpItem = 0;
	if (QsToShow > QList.length){
		QsToShow = QList.length;
	}
	while (QsToShow < QList.length){
		DumpItem = Math.floor(QList.length*Math.random());
		for (j=DumpItem; j<(QList.length-1); j++){
			QList[j] = QList[j+1];
		}
		QList.length = QList.length-1;
	}
	if (ShuffleQs == true){
		QList = Shuffle(QList);
	}
	if (ShuffleAs == true){
		var As;
		for (var i=0; i<QList.length; i++){
			As = QList[i].getElementsByTagName('ol')[0];
			if (As != null){
  			AList.length = 0;
				while (As.getElementsByTagName('li').length > 0){
					AList.push(As.removeChild(As.getElementsByTagName('li')[0]));
				}
				AList = Shuffle(AList);
				for (j=0; j<AList.length; j++){
					As.appendChild(AList[j]);
				}
			}
		}
	}
	
	for (i=0; i<QList.length; i++){
		Qs.appendChild(QList[i]);
		QArray[QArray.length] = QList[i];
	}

//Show the first item
	QArray[0].style.display = '';
	
//Now hide all except the first item
	for (i=1; i<QArray.length; i++){
		QArray[i].style.display = 'none';
	}		
	SetQNumReadout();
	
	SetFocusToTextbox();
}

function SetFocusToTextbox(){
//if there's a textbox, set the focus in it
	if (QArray[CurrQNum].getElementsByTagName('input')[0] != null){
// modif HQeL le 19/09/08 : on ne veut le focus et le keypad que si c'est un champ texte (qu'on n'utilise pas ici...)
                if (QArray[CurrQNum].getElementsByTagName('input')[0].type=='text') {
		  QArray[CurrQNum].getElementsByTagName('input')[0].focus();
//and show a keypad if there is one
		  if (document.getElementById('CharacterKeypad') != null){
			document.getElementById('CharacterKeypad').style.display = 'block';
                  }
		}
	}
	else{
  	if (QArray[CurrQNum].getElementsByTagName('textarea')[0] != null){
  		QArray[CurrQNum].getElementsByTagName('textarea')[0].focus();	
//and show a keypad if there is one
			if (document.getElementById('CharacterKeypad') != null){
				document.getElementById('CharacterKeypad').style.display = 'block';
			}
		}
//This added for 6.0.4.11: hide accented character buttons if no textbox
		else{
			if (document.getElementById('CharacterKeypad') != null){
				document.getElementById('CharacterKeypad').style.display = 'none';
			}
		}
	}
}

function ChangeQ(ChangeBy){
//The following line prevents moving to another question until the current
//question is answered correctly. Uncomment it to enable this behaviour. 
//	if (State[CurrQNum][0] == -1){return;}
	if (((CurrQNum + ChangeBy) < 0)||((CurrQNum + ChangeBy) >= QArray.length)){
	//modif HQeL
	if ((CurrQNum + ChangeBy) >= QArray.length)
	{CheckFinished();
	if (Finished==true)
		{
		close();
		}
		else
		{ShowMessage('R&#233;ponse non donn&#233;e !');}
	}
	// HQeL
	return;
	}
	QArray[CurrQNum].style.display = 'none';
	CurrQNum += ChangeBy;
	QArray[CurrQNum].style.display = '';
//Undocumented function added 10/12/2004
	ShowSpecialReadingForQuestion();
	SetQNumReadout();
	SetFocusToTextbox();
}

var HiddenReadingShown = false;
function ShowSpecialReadingForQuestion(){
//Undocumented function for showing specific reading text elements which change with each question
//Added on 10/12/2004
	if (document.getElementById('ReadingDiv') != null){
		if (HiddenReadingShown == true){
			document.getElementById('ReadingDiv').innerHTML = '';
		}
		if (QArray[CurrQNum] != null){
//Fix for 6.0.4.25
			var Children = QArray[CurrQNum].getElementsByTagName('div');
			for (var i=0; i<Children.length; i++){
			if (Children[i].className=="HiddenReading"){
					document.getElementById('ReadingDiv').innerHTML = Children[i].innerHTML;
					HiddenReadingShown = true;
//Hide the ShowAllQuestions button to avoid confusion
					if (document.getElementById('ShowMethodButton') != null){
						document.getElementById('ShowMethodButton').style.display = 'none';
					}
				}
			}	
		}
	}
}

function SetQNumReadout(){
	// modif HQeL si pas de titre
	if (document.getElementById('Txt').innerHTML=='')
		document.getElementById('Title').style.display='none';			
	// modif HQeL (si 1 question on n'affiche pas X/Y)
	if (QArray.length > 1)
		{document.getElementById('QNumReadout').innerHTML = (CurrQNum+1) + ' / ' + QArray.length;}
	else
		{document.getElementById('QNumReadout').style.display='none';}
	if ((CurrQNum+1) >= QArray.length){
		if (document.getElementById('NextQButton') != null){
			document.getElementById('NextQButton').style.visibility = 'hidden';
			//document.getElementById('NextQButton').innerHTML='Terminer'; // ajout HQeL ?
			//document.getElementById('NextQButton').style.visibility = 'visible'; // ajout HQeL ?
		}
	}
	else{
		if (document.getElementById('NextQButton') != null){
			document.getElementById('NextQButton').style.visibility = 'visible';
		}
	}
	if (CurrQNum <= 0){
		if (document.getElementById('PrevQButton') != null){
			document.getElementById('PrevQButton').style.visibility = 'hidden';
		}
	}
	else{
		if (document.getElementById('PrevQButton') != null){
			document.getElementById('PrevQButton').style.visibility = 'visible';
		}
	}
}

var I=new Array();
I[0]=new Array();I[0][0]=100;
I[0][1]='';
I[0][2]='0';
I[0][3]=new Array();
I[0][3][0]=new Array('Oui','',1,100,1);
I[0][3][1]=new Array('Non','',0,0,1);
I[1]=new Array();I[1][0]=100;
I[1][1]='';
I[1][2]='0';
I[1][3]=new Array();
I[1][3][0]=new Array('Oui','',0,0,1);
I[1][3][1]=new Array('Non','',1,100,1);
I[2]=new Array();I[2][0]=100;
I[2][1]='';
I[2][2]='0';
I[2][3]=new Array();
I[2][3][0]=new Array('Oui','',1,100,1);
I[2][3][1]=new Array('Non','',0,0,1);
I[3]=new Array();I[3][0]=100;
I[3][1]='';
I[3][2]='3';
I[3][3]=new Array();
I[3][3][0]=new Array('Evaluer les co\u00FBts de mise en oeuvre.','',0,0,1);
I[3][3][1]=new Array('Selon le cas planifier les op\u00E9rations de v\u00E9rification, validation, surveillance.','',1,100,1);
I[3][3][2]=new Array('D\u00E9terminer selon le cas les contr\u00F4les et essais.','',1,100,1);
I[3][3][3]=new Array('D\u00E9terminer selon le cas des objectifs Qualit\u00E9 pour le produit.','',1,100,1);
I[4]=new Array();I[4][0]=100;
I[4][1]='';
I[4][2]='3';
I[4][3]=new Array();
I[4][3][0]=new Array('D\u00E9signer un responsable produit.','',0,0,1);
I[4][3][1]=new Array('D\u00E9terminer la n\u00E9cessit\u00E9 de mettre en place les processus, \u00E9tablir les documents et fournir les ressources sp\u00E9cifiques au produit.','',1,100,1);
I[4][3][2]=new Array('D\u00E9terminer les enregistrements pour apporter la preuve de la conformit\u00E9 du produit aux exigences.','',1,100,1);


function StartUp(){
	RemoveBottomNavBarForIE();

//If there's only one question, no need for question navigation controls
	if (QsToShow < 2){
		document.getElementById('QNav').style.display = 'none';
		if (document.getElementById('ShowMethodButton') != null){
			document.getElementById('ShowMethodButton').style.visibility = 'hidden';
			}
	}
	
//Stash the instructions so they can be redisplayed
	strInstructions = document.getElementById('InstructionsDiv').innerHTML;
	

	ScormStartUp();

	

	

	PreloadImages('+QuestMultIndicator+','+QuestIndicator+','+ImgInd+','+ImgChk+','+ImgUnChk+');

	
	CompleteEmptyFeedback();

	SetUpQuestions();
	ClearTextBoxes();
	CreateStatusArray();
	

	
//Check search string for q parameter
	if (document.location.search.length > 0){
		if (ShuffleQs == false){
			var JumpTo = parseInt(document.location.search.substring(1,document.location.search.length))-1;
			if (JumpTo <= QsToShow){
				ChangeQ(JumpTo);
			}
		}
	}
//Undocumented function added 10/12/2004
	ShowSpecialReadingForQuestion();
}

function ShowHideQuestions(){
	FuncBtnOut(document.getElementById('ShowMethodButton'));
	document.getElementById('ShowMethodButton').style.display = 'none';
	if (ShowingAllQuestions == false){
		for (var i=0; i<QArray.length; i++){
				QArray[i].style.display = '';
			}
		document.getElementById('Questions').style.listStyleType = 'decimal';
		document.getElementById('OneByOneReadout').style.display = 'none';
		document.getElementById('ShowMethodButton').innerHTML = ShowOneByOneCaption;
		ShowingAllQuestions = true;
	}
	else{
		for (var i=0; i<QArray.length; i++){
				if (i != CurrQNum){
					QArray[i].style.display = 'none';
				}
			}
		document.getElementById('Questions').style.listStyleType = 'none';
		document.getElementById('OneByOneReadout').style.display = '';
		document.getElementById('ShowMethodButton').innerHTML = ShowAllQuestionsCaption;
		ShowingAllQuestions = false;	
	}
	document.getElementById('ShowMethodButton').style.display = 'inline';
}

function CreateStatusArray(){
// modif HQeL
	var QuestIndicator='question.png';
	var QuestMultIndicator='questionM.png';
//
	var QNum, ANum;
//For each item in the item array
	for (QNum=0; QNum<I.length; QNum++){
//Check if the question still exists (hasn't been nuked by showing a random selection)
		if (document.getElementById('Q_' + QNum) != null){
			State[QNum] = new Array();
			State[QNum][0] = -1; //Score for this q; -1 shows question not done yet
			State[QNum][1] = new Array(); //answers
			State[QNum][6] = 0; //modif HQeL : pour calcul du nombre d'essais autoris&#233;
			for (ANum = 0; ANum<I[QNum][3].length; ANum++){
				State[QNum][1][ANum] = 0; //answer not chosen yet; when chosen, will store its position in the series of choices
			        //modif HQeL : calcul du nombre de r&#233;ponses justes pour nombre d'essais maxi
                                if (I[QNum][3][ANum][2]>=1) {State[QNum][6]++;}
			}
			// modif HQeL
			for (ANum = 0; ANum<I[QNum][3].length; ANum++){
				State[QNum][1][ANum] = 0; //answer not chosen yet; when chosen, will store its position in the series of choices
				// ajout HQeL
				if (document.getElementById('Q_' + QNum+'_'+ANum+'_Btn') != null) {
				if (State[QNum][6]>1){document.getElementById('Q_' + QNum+'_'+ANum+'_Btn').innerHTML='<IMG SRC='+QuestMultIndicator+'>';}
				else {document.getElementById('Q_' + QNum+'_'+ANum+'_Btn').innerHTML='<IMG SRC='+QuestIndicator+'>';}  
				// ajout HQeL
				}
			}
			State[QNum][2] = 0; //tries at this q so far
			State[QNum][3] = 0; //incrementing percent-correct values of selected answers
			State[QNum][4] = 0; //penalties incurred for hints
			State[QNum][5] = ''; //Sequence of answers chosen by number
		      }
		else{
			State[QNum] = null;
		}
	}
}




// test du clic sur le bouton de s&#233;lection de la r&#233;ponse
function CheckMCAnswer(QNum, ANum, Btn){
// modif HQeL
var ImgInd='response.png';
Indicator='<IMG SRC='+ImgInd+'>';

//if question doesn't exist, bail
	if (State[QNum].length < 1){return;}

//Get the feedback
	Feedback = I[QNum][3][ANum][1];
	
//Now show feedback and bail if question already complete // modif HQeL
//	if (State[QNum][0] > -1){

var RemainingAnswer = FinishAnswer(QNum); // on ne peut plus choisir de r&#233;ponse
	if (RemainingAnswer > -1){
//Add an extra message explaining that the question
// is finished if defined by the user
		if (strQuestionFinished.length > 0){Feedback += '<br />' + strQuestionFinished;}
//Show the feedback
// modif HQeL : on n'affiche le feedback que s'il y en a un
		if (Feedback!='')
        	{
		ShowMessage(Feedback);
			}
		return;
	}
	
//Hide the button while processing
	Btn.style.display = 'none';

//Increment the number of tries
	State[QNum][2]++;
	
//Add the percent-correct value of this answer
	State[QNum][3] += I[QNum][3][ANum][3];
	
//Store the try number in the answer part of the State array, for tracking purposes
	State[QNum][1][ANum] = State[QNum][2];
	if (State[QNum][5].length > 0){State[QNum][5] += ' | ';}
	State[QNum][5] += String.fromCharCode(65+ANum);
	
//Should this answer be accepted as correct?
	if (I[QNum][3][ANum][2] < 1){
//It's wrong

//Mark the answer
		//Btn.innerHTML = IncorrectIndicator; modif HQeL
		Btn.innerHTML = Indicator;
		
//Remove any previous score unless exercise is finished (6.0.3.8+)
		if (Finished == false){
			WriteToInstructions(strInstructions);
		}	
		
//Check whether this leaves just one MC answer unselected, in which case the Q is terminated
		//var RemainingAnswer = FinalAnswer(QNum); // modif HQeL
//		if (RemainingAnswer > -1){
//Behave as if the last answer had been selected, but give no credit for it
//Increment the number of tries
			State[QNum][2]++;		
		
//Calculate the score for this question
			CalculateMCQuestionScore(QNum);

//Get the overall score and add it to the feedback
			CalculateOverallScore();
			if ((ContinuousScoring == true)||(Finished == true)){
				Feedback += '<br />' + YourScoreIs + ' ' + Score + '%.';
				WriteToInstructions(YourScoreIs + ' ' + Score + '%.');
			}
		//}
	}
	else{
//It's right
//Mark the answer
		//Btn.innerHTML = CorrectIndicator; modif HQeL
		Btn.innerHTML = Indicator;
				
//Calculate the score for this question
		CalculateMCQuestionScore(QNum);

//Get the overall score and add it to the feedback
		if (ContinuousScoring == true){
			CalculateOverallScore();
			if ((ContinuousScoring == true)||(Finished == true)){
				Feedback += '<br />' + YourScoreIs + ' ' + Score + '%.';
				WriteToInstructions(YourScoreIs + ' ' + Score + '%.');
			}
		}
	}
	
//Show the button again
	Btn.style.display = 'inline';
	
//Finally, show the feedback
// modif HQeL : s'il n'y a pas de feedback on n'affiche pas de message
if (Feedback!='')
    {	
	ShowMessage(Feedback);
	}

//Check whether all questions are now done
	CheckFinished();
}

function CalculateMCQuestionScore(QNum){
	var Tries = State[QNum][2] + State[QNum][4]; //include tries and hint penalties
	var PercentCorrect = State[QNum][3];
	var TotAns = GetTotalMCAnswers(QNum);
	var HintPenalties = State[QNum][4];
	
//Make sure it's not already complete

	if (State[QNum][0] < 0){
//Allow for Hybrids
		if (HintPenalties >= 1){
			State[QNum][0] = 0;
		}
		else{
//This line calculates the score for this question
			if (TotAns == 1){
				State[QNum][0] = 1;
			}
			else{
				State[QNum][0] = ((TotAns-((Tries*100)/State[QNum][3]))/(TotAns-1));
			}
		}
//Fix for Safari bug added for version 6.0.3.42 (negative infinity problem)
		if ((State[QNum][0] < 0)||(State[QNum][0] == Number.NEGATIVE_INFINITY)){
			State[QNum][0] = 0;
		}
	}
}

// calcul du nombre de QCM
function GetTotalMCAnswers(QNum){
	var Result = 0;
	for (var ANum=0; ANum<I[QNum][3].length; ANum++){
		if (I[QNum][3][ANum][4] == 1){ //This is an MC answer
			Result++;
		}
	}
	return Result;
}

// ajout HQeL : on v&#233;rifie si on peut encore choisir une r&#233;ponse
function FinishAnswer(QNum){
	var ChosenAnswers = 0;
	var FinishAnswer = -1;
	for (var ANum=0; ANum<I[QNum][3].length; ANum++){
		if (I[QNum][3][ANum][4] == 1){ //This is an MC answer
			if (State[QNum][1][ANum] >= 1){ //la r&#233;ponse a &#233;t&#233; choisie
				ChosenAnswers++;
			}
		}
	}
	if (ChosenAnswers >= State[QNum][6]){
		FinishAnswer = 1; // on a fini, on ne peut plus choisir de r&#233;ponse
	}
return FinishAnswer;
}
// HQeL

function FinalAnswer(QNum){
	var UnchosenAnswers = 0;
	var FinalAnswer = -1;
	for (var ANum=0; ANum<I[QNum][3].length; ANum++){
		if (I[QNum][3][ANum][4] == 1){ //This is an MC answer
			if (State[QNum][1][ANum] < 1){ //This answer hasn't been chosen yet
				UnchosenAnswers++;
				FinalAnswer = ANum;
			}
		}
	}
	if (UnchosenAnswers == 1){
		return FinalAnswer;
	}
	else{
		return -1;
	}
}






// ajout HQeL : fonction qui traite le contenu des forms dans le cas des multi s&#233;lections
function AfficheSel(Q)
{
var innerQ='';
var scindeChamp, sousChamp;;
var iPos,i;
var ImgChk='chk.png';
var SChk='<IMG SRC='+ImgChk+'> ';
var ImgUnChk='unchk.png';
var SUnChk='<IMG SRC='+ImgUnChk+'> ';
var CheckBox = null;
// on remplace d'abord les input par des images
for (var i=0; i<I[Q][3].length; i++)
	{   
	innerQ = document.getElementById('Q_'+Q+'_'+i).innerHTML;
	scindeChamp=innerQ.split('<INPUT'); 
	if (scindeChamp[1]== null) //(firefox -> on n'a pas trouv&#233; INPUT - majuscules, on cherche en minuscules)
		{scindeChamp=innerQ.split('<input');}
	innerQ=scindeChamp[0];
	iPos=scindeChamp[1].indexOf('>');
	sousChamp=scindeChamp[1].substring(iPos+1,scindeChamp[1].length);
	CheckBox=document.getElementById('Q_'+Q+'_'+i+'_Chk');
	if (CheckBox.checked == true)   
		{scindeChamp[0]=SChk+sousChamp;}
		else
		{scindeChamp[0]=SUnChk+sousChamp;}	
	innerQ=innerQ+scindeChamp[0];
	document.getElementById('Q_'+Q+'_'+i).innerHTML=innerQ;
	}
// on enl&#232;ve le bouton Valider
innerQ=document.getElementById('Q_'+Q).innerHTML;
scindeChamp=innerQ.split('<BUTTON'); 
if (scindeChamp[1]== null) //(firefox -> on n'a pas trouv&#233; BUTTON - majuscules, on cherche en minuscules)
		{scindeChamp=innerQ.split('<button');}
innerQ=scindeChamp[0];
document.getElementById('Q_'+Q).innerHTML=innerQ;
}
// HQeL

// MULTI-SELECTION
function CheckMultiSelAnswer(QNum){
//bail if question doesn't exist or exercise finished
	if ((State[QNum].length < 1)||(Finished == true)){return;}
//Increment the tries for this question

	State[QNum][2]++;
	
	var ShouldBeChecked;
	var Matches = 0;
	if (State[QNum][5].length > 0){State[QNum][5] += ' | ';}
	
//Check if there are any mismatches
	Feedback = '';
	var CheckBox = null;
	for (var ANum=0; ANum<I[QNum][3].length; ANum++){
		CheckBox = document.getElementById('Q_' + QNum + '_' + ANum + '_Chk');
		if (CheckBox.checked == true){
			State[QNum][5] += 'Y';
		}
		else{
			State[QNum][5] += 'N';
		}
		ShouldBeChecked = (I[QNum][3][ANum][2] == 1);
		if (ShouldBeChecked == CheckBox.checked){
			Matches++;
		}
		//else{                                  //modif HQeL : s'il y a un feedback on veut l'afficher m&#234;me si la r&#233;ponse est juste
			Feedback = I[QNum][3][ANum][1];
		//}
	}
//Add the hit readout
// modif HQeL : on ne rajoute pas l'info x/y
//	Feedback = Matches + ' / ' + I[QNum][3].length + '<br />' + Feedback;
	if (Matches == I[QNum][3].length){
//It's right
		CalculateMultiSelQuestionScore(QNum);
		if (ContinuousScoring == true){
			CalculateOverallScore();
			if ((ContinuousScoring == true)||(Finished == true)){
				Feedback += '<br />' + YourScoreIs + ' ' + Score + '%.';
				WriteToInstructions(YourScoreIs + ' ' + Score + '%.');
			}
		}
	}
	else{
//It's wrong -- Remove any previous score unless exercise is finished (6.0.3.8+)
		// modif HQeL
		State[QNum][0] = 0; // si c'est faux le score est nul
		if (Finished == false){
			WriteToInstructions(strInstructions);
		}	
	}
		
// modif HQeL
AfficheSel(QNum);

//modif HQeL : on ne veut pas de feedback type x/y mais une explication s'il y en a une
//Show the feedback
if (Feedback!='')
        {
		ShowMessage(Feedback); 
		}
//Check whether all questions are now done
	CheckFinished();
}

function CalculateMultiSelQuestionScore(QNum){
	var Tries = State[QNum][2];           // les essais
	var TotAns = State[QNum][1].length;  // nombre total de r&#233;ponses
	
//Make sure it's not already complete
	if (State[QNum][0] < 0){
		State[QNum][0] = (TotAns - (Tries-1)) / TotAns;
		if (State[QNum][0] < 0){
			State[QNum][0] = 0;
		}
	}
}



function CalculateOverallScore(){
	var TotalWeighting = 0;
	var TotalScore = 0;
	
	for (var QNum=0; QNum<State.length; QNum++){
		if (State[QNum] != null){
			if (State[QNum][0] > -1){
				TotalWeighting += I[QNum][0];
				TotalScore += (I[QNum][0] * State[QNum][0]);
			}
		}
	}
	if (TotalWeighting > 0){
		Score = Math.floor((TotalScore/TotalWeighting)*100);
	}
	else{
//if TotalWeighting is 0, no questions so far have any value, so 
//no penalty should be shown.
		Score = 100; 
	}
}

function CheckFinished(){
	var FB = '';
	var AllDone = true;
	for (var QNum=0; QNum<State.length; QNum++){
		if (State[QNum] != null){			
			if (State[QNum][0] < 0){
				AllDone = false;
			}
		}
	}
	if (AllDone == true){
	
//Report final score and submit if necessary
		CalculateOverallScore();
		FB = YourScoreIs + ' ' + Score + '%.';
		if (ShowCorrectFirstTime == true){
			var CFT = 0;
			for (QNum=0; QNum<State.length; QNum++){
				if (State[QNum] != null){
					if (State[QNum][0] >= 1){
						CFT++;
					}
				}
			}
			FB += '<br />' + CorrectFirstTime + ' ' + CFT + '/' + QsToShow;
		}
		WriteToInstructions(FB);
		
		Finished == true;



		if (TimeOver == true){
			SetScormTimedOut();
		}
		else{
			SetScormComplete();
		}


		TimeOver = true;
		Locked = true;
		


		Finished = true;
		Detail = '<?xml version="1.0"?><hpnetresult><fields>';
		for (QNum=0; QNum<State.length; QNum++){
			if (State[QNum] != null){
				if (State[QNum][5].length > 0){
					Detail += '<field><fieldname>Question #' + (QNum+1) + '</fieldname><fieldtype>question-tracking</fieldtype><fieldlabel>Q ' + (QNum+1) + '</fieldlabel><fieldlabelid>QuestionTrackingField</fieldlabelid><fielddata>' + State[QNum][5] + '</fielddata></field>';
				}
			}
		}
		Detail += '</fields></hpnetresult>';
		setTimeout('Finish()', SubmissionTimeout);
	}

	else{
		SetScormIncomplete();
	}

}










//-->

//]]>


